#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include <sysutils.hpp> //Win32Check()

#define bufferLength 256

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------

GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;
DWORD requiredSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
typedef struct _HIDD_ATTRIBUTES
  {
    ULONG Size;
    USHORT VendorID;
    USHORT ProductID;
    USHORT VersionNumber;
} HIDD_ATTRIBUTES, *PHIDD_ATTRIBUTES;

HANDLE  hidDeviceObject;
HIDD_ATTRIBUTES hiddAttributes;
wchar_t buffer[bufferLength];

int main()
{

  void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
  bool (__stdcall *HidD_GetAttributes)(IN HANDLE HidDeviceObject,
                                       OUT PHIDD_ATTRIBUTES Attributes);
  bool (__stdcall *HidD_GetProductString)(IN HANDLE HidDeviceObject,
                                          OUT PVOID  Buffer,
                                          IN ULONG  BufferLength);
  bool (__stdcall *HidD_GetManufacturerString)(IN HANDLE HidDeviceObject,
                                          OUT PVOID  Buffer,
                                          IN ULONG  BufferLength);
  bool (__stdcall *HidD_GetPhysicalDescriptor)(IN HANDLE HidDeviceObject,
                                    OUT PVOID Buffer, IN ULONG  BufferLength);
  bool (__stdcall *HidD_GetMsGenreDescriptor)(IN HANDLE   HidDeviceObject,
                                   OUT PVOID Buffer, IN ULONG BufferLength);


  hHidLib = LoadLibrary("HID.DLL");
  if (!hHidLib)
    displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
   (FARPROC&) HidD_GetAttributes=GetProcAddress(hHidLib, "HidD_GetAttributes");
   (FARPROC&) HidD_GetProductString=GetProcAddress(hHidLib,
                                                    "HidD_GetProductString");
   (FARPROC&) HidD_GetManufacturerString=GetProcAddress(hHidLib,
                                                "HidD_GetManufacturerString");

   (FARPROC&) HidD_GetPhysicalDescriptor=GetProcAddress(hHidLib,
                                                "HidD_GetPhysicalDescriptor");

   (FARPROC&) HidD_GetMsGenreDescriptor=GetProcAddress(hHidLib,
                                                "HidD_GetMsGenreDescriptor");

   if (!HidD_GetHidGuid || !HidD_GetAttributes || !HidD_GetProductString ||
       !HidD_GetManufacturerString || !HidD_GetPhysicalDescriptor ||
       !HidD_GetMsGenreDescriptor){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
            FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
}

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
   hiddAttributes.Size = sizeof(HIDD_ATTRIBUTES);

   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            &requiredSize, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                  GENERIC_READ, FILE_SHARE_READ,
                                  NULL, OPEN_EXISTING, 0, NULL );
       if(hidDeviceObject != INVALID_HANDLE_VALUE) {
          cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";

          HidD_GetManufacturerString(hidDeviceObject, buffer, bufferLength);
          printf("Producent = %ls\n", buffer);

          HidD_GetAttributes(hidDeviceObject, &hiddAttributes);
          printf("VID/PID/wersja = %x/%x/%x\n",hiddAttributes.VendorID,
                                               hiddAttributes.ProductID,
                                               hiddAttributes.VersionNumber);

          HidD_GetProductString(hidDeviceObject, buffer, bufferLength);
          printf("Urzadzenie = %ls\n", buffer);

          HidD_GetPhysicalDescriptor(hidDeviceObject, buffer, bufferLength);
          printf("Deskryptor fizyczny = %ls\n", buffer);

          HidD_GetMsGenreDescriptor(hidDeviceObject, buffer, bufferLength);
          printf("Deskryptor Microsoft = %ls\n", buffer);

          Win32Check(CloseHandle(hidDeviceObject));
       }
       releaseMemory(deviceInterfaceDetailData);
    };//koniec while

   //Win32Check(CloseHandle(hidDeviceObject));
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

